unit Pzdlview;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, PZBPanel, PZShaded, StdCtrls, PZLabel, PZSpButt,
  PZLView;

type
  TPZListViewForm = class(TForm)
    HeaderPanel: TPZBitmapPanel;
    PZShaded1: TPZShaded;
    DescrPanel: TPZBitmapPanel;
    PZLabel4: TPZLabel;
    ResultsPanel: TPZBitmapPanel;
    PZLabel2: TPZLabel;
    PZLabel1: TPZLabel;
    OutputPanel1: TPZBitmapPanel;
    FishView: TPZListView;
    OutputPanel2: TPZBitmapPanel;
    BackgroundCheck: TCheckBox;
    Label1: TLabel;
    PZLabel3: TPZLabel;
    PZLabel5: TPZLabel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure Label1Click(Sender: TObject);
    procedure BackgroundCheckClick(Sender: TObject);
    function FishViewCompareItems(Index1, Index2,
      Column: Integer): Integer;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  PZListViewForm: TPZListViewForm;

implementation

Uses PZDMain;

{$R *.DFM}

procedure TPZListViewForm.FormCreate(Sender: TObject);

Begin
  SetBounds(10,10,MainForm.ClientWidth-20,MainForm.ClientHeight-MainForm.MainPanel.Height-20);
  HeaderPanel.Background.LoadBitmap('PZD_STONE');
  DescrPanel.Background.LoadBitmap('PZD_STONE');
  ResultsPanel.Background.LoadBitmap('PZD_STONE');
  OutputPanel1.Background.LoadBitmap('PZD_STONE');
  OutputPanel2.Background.LoadBitmap('PZD_STONE');
End;

procedure TPZListViewForm.FormClose(Sender: TObject;  var Action: TCloseAction);

Begin
  Action:=caFree;
End;

procedure TPZListViewForm.FormDeactivate(Sender: TObject);
begin
  Close;
end;

procedure TPZListViewForm.Label1Click(Sender: TObject);
begin
  If BackgroundCheck.State=cbChecked Then
    BackgroundCheck.State:=cbUnchecked
  Else
    BackgroundCheck.State:=cbChecked;
  BackgroundCheck.SetFocus;
end;

procedure TPZListViewForm.BackgroundCheckClick(Sender: TObject);
begin
  If BackgroundCheck.State=cbChecked Then
    FishView.Background.LoadBitmap('PZD_FISH')
  Else
    FishView.Background.Bitmap.Assign(Nil);
end;

function TPZListViewForm.FishViewCompareItems(Index1, Index2,
  Column: Integer): Integer;

Var
  Item1,Item2 :String;
  l1,l2       :Double;

begin
  Result:=0;
  Item1:=ItemToItemPart(FishView.Items[Index1],Column);
  Item2:=ItemToItemPart(FishView.Items[Index2],Column);
  If Column<4 Then
    Begin
      If Item1<Item2 Then
        Result:=-1
      Else If Item1>Item2 Then
        Result:=1;
    End
  Else
    Begin
      l1:=StrToFloat(Item1);
      l2:=StrToFloat(Item2);
      If l1<l2 Then
        Result:=-1
      Else If l1>l2 Then
        Result:=1;
    End;
end;

end.
